/************************************************************************
 *
 * \file: mspin_demo_iap2_gadget_loader.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: mySPIN - Demo application
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/
#include "mspin_logging.h"
#include <mspin_demo_iap2_gadget_loader.h>
#include <string.h>
#include <glob.h>
#include <libkmod.h>
#include <sys/utsname.h>
#include <sys_time_adit.h>
#include <sys/stat.h>
#include <sys/mount.h>
#include <errno.h>


GadgetLoader::GadgetLoader()
{

}
GadgetLoader::~GadgetLoader()
{

}

uint32_t GadgetLoader::iap2CurrTimeMs(void)
{
    uint32_t timeMs;
    struct timeval tp;
    gettimeofday (&tp, NULL);
    timeMs = iap2CurrTimeValToMs(&tp);

    return timeMs;
}

uint32_t GadgetLoader::iap2CurrTimeValToMs(struct timeval* currTime)
{
    return (uint32_t)(currTime->tv_sec * 1000) + (uint32_t)(currTime->tv_usec / 1000);
}

int32_t GadgetLoader::LoadKernelModule(const iap2LoadModuleParameters* iap2ModuleLoadParam, const char* modname, uint32_t length)
{
    int rc = -1;
    struct kmod_ctx *ctx;
    struct kmod_module *module;

    ctx = kmod_new(NULL, NULL);
    if (ctx == NULL)
    {
        mspin_log_printLn(eMspinVerbosityError,"%s() kmod_new() failed", __FUNCTION__);
        rc = -1;
    }
    else
    {
        rc = kmod_module_new_from_name(ctx, modname, &module);
        if (rc)
        {
            mspin_log_printLn(eMspinVerbosityError,"%s() kmod_module_new_from_name() failed", __FUNCTION__);
            rc = -1;
        }
        else
        {
            mspin_log_printLn(eMspinVerbosityDebug,"%s() modname='%s' obj=%p", __FUNCTION__, modname, module);

            if (strncmp(modname, CONFIGFS_MODULE_NAME, length) == 0)
            {
                if (iap2ModuleLoadParam != NULL)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() No parameters supported for module %s",
                            __FUNCTION__, kmod_module_get_name(module));
                    return -1;
                }

                rc = kmod_module_insert_module(module, KMOD_PROBE_APPLY_BLACKLIST, NULL);
                if (0 == rc)
                {
                    mspin_log_printLn(eMspinVerbosityDebug,"%s() %u ms iap2LoadModule() loaded module %s",
                            __FUNCTION__, iap2CurrTimeMs(), kmod_module_get_name(module));
                }
                else if (rc == KMOD_PROBE_APPLY_BLACKLIST)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() module %s black listed",
                            __FUNCTION__, kmod_module_get_name(module));
                }
                else
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s()  failed to insert module %s | err = %d",
                            __FUNCTION__, kmod_module_get_name(module), rc);
                }

            }
            else if (strncmp(modname, LIBCOMPOSITE_MODULE_NAME, length) == 0)
            {
                if (iap2ModuleLoadParam != NULL)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() No parameters supported for module %s",
                            __FUNCTION__, kmod_module_get_name(module));
                    return -1;
                }

                rc = kmod_module_insert_module(module, KMOD_PROBE_APPLY_BLACKLIST, NULL);
                if (0 == rc)
                {
                    mspin_log_printLn(eMspinVerbosityDebug, "%s() %u ms iap2LoadModule() loaded module %s",
                            __FUNCTION__, iap2CurrTimeMs(), kmod_module_get_name(module));
                }
                else if (rc == KMOD_PROBE_APPLY_BLACKLIST)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() module %s black listed",
                            __FUNCTION__, kmod_module_get_name(module));
                }
                else
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() failed to insert module %s | err = %d",
                            __FUNCTION__, kmod_module_get_name(module), rc);
                }
            }
            else if (strncmp(modname, USB_F_FS_MODULE_NAME, length) == 0)
            {
                if (iap2ModuleLoadParam != NULL)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() No parameters supported for module %s",
                            __FUNCTION__, kmod_module_get_name(module));
                    return -1;
                }

                rc = kmod_module_insert_module(module, KMOD_PROBE_APPLY_BLACKLIST, NULL);
                if (0 == rc)
                {
                    mspin_log_printLn(eMspinVerbosityDebug, "%s() %u ms iap2LoadModule() loaded module %s",
                            __FUNCTION__, iap2CurrTimeMs(), kmod_module_get_name(module));
                }
                else if (rc == KMOD_PROBE_APPLY_BLACKLIST)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() module %s black listed\n",
                            __FUNCTION__, kmod_module_get_name(module));
                } else
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() failed to insert module %s | err = %d",
                            __FUNCTION__, kmod_module_get_name(module), rc);
                }
            }
            else if (strncmp(modname, U_ETHER_MODULE_NAME, length) == 0)
            {
                if (iap2ModuleLoadParam != NULL)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() No parameters supported for module %s",
                            __FUNCTION__, kmod_module_get_name(module));
                    return -1;
                }

                rc = kmod_module_insert_module(module, KMOD_PROBE_APPLY_BLACKLIST, NULL);
                if (0 == rc)
                {
                    mspin_log_printLn(eMspinVerbosityDebug, "%s() %u ms iap2LoadModule() loaded module %s",
                            __FUNCTION__, iap2CurrTimeMs(), kmod_module_get_name(module));
                }
                else if (rc == KMOD_PROBE_APPLY_BLACKLIST)
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() module %s black listed",
                            __FUNCTION__, kmod_module_get_name(module));
                }
                else
                {
                    mspin_log_printLn(eMspinVerbosityError, "%s() failed to insert module %s | err = %d",
                            __FUNCTION__, kmod_module_get_name(module), rc);
                }
            }
            else
            {
                /* error. unknown module name */
                mspin_log_printLn(eMspinVerbosityError, "%s() unknown module name", __FUNCTION__);
                rc = -1;
            }
            kmod_module_unref(module);
        }
        kmod_unref(ctx);
    }

    return rc;
}

int32_t GadgetLoader::UnloadKernelModule(const char* modname)
{
    int rc = -1;
    struct kmod_ctx *ctx;
    struct kmod_module *module;

    ctx = kmod_new(NULL, NULL);
    if (ctx == NULL)
    {
        mspin_log_printLn(eMspinVerbosityError, "%s() kmod_new() failed", __FUNCTION__);
        rc = -1;
    }
    else
    {
        rc = kmod_module_new_from_name(ctx, modname, &module);
        if (rc)
        {
            mspin_log_printLn(eMspinVerbosityError, "%s() kmod_module_new_from_name() failed", __FUNCTION__);
            rc = -1;
        }
        else
        {
            mspin_log_printLn(eMspinVerbosityDebug, "%s() modname='%s' obj=%p", __FUNCTION__, modname, module);

            rc = kmod_module_remove_module(module, KMOD_REMOVE_FORCE);
            if (0 == rc)
            {
                mspin_log_printLn(eMspinVerbosityDebug, "%s() %u ms  iap2UnloadModule()  unloaded module %s",
                        __FUNCTION__, iap2CurrTimeMs(), kmod_module_get_name(module));
            }
            else if (rc == KMOD_PROBE_APPLY_BLACKLIST)
            {
                mspin_log_printLn(eMspinVerbosityError, "%s() module %s black listed",
                        __FUNCTION__, kmod_module_get_name(module));
            }
            else
            {
                mspin_log_printLn(eMspinVerbosityError, "%s() failed to remove module %s | err = %d",
                        __FUNCTION__, kmod_module_get_name(module), rc);
            }
            kmod_module_unref(module);
        }
        kmod_unref(ctx);
    }

    return rc;
}

